<?php

namespace App\Http\Controllers;

use App\Http\Requests\MunicipioRequest;
use App\Models\entidade;
use App\Models\Municipio;
use App\Models\Province;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

use function PHPUnit\Framework\isInt;

class MunicipioController extends Controller
{
    /**
     * Display a listing of the resource.
     */ 
    public function index()
    {
        $user =  auth()->user();
        $municipios = DB::table('municipios')
        ->join('entidades','entidades.id','=','municipios.entidade_id')
        ->join('provinces','provinces.id','=','municipios.province_id')
        ->join('users','users.id','=','municipios.user_id')
        ->select('users.name', 'entidades.nome as nomeEntidade', 
        'provinces.nome as nomeprovincia','provinces.user_id as responsavelprovincia_id','municipios.*')
        ->where("entidades.id",$user->entidade_id)
        ->paginate(10);
        return view('municipio.index', compact('municipios','user'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $user =  auth()->user();
        if($user->role_id==1 or $user->role_id==2){
            
            $provincias = Province::get()->where("entidade_id",$user->entidade_id);

            $users = DB::table('users')
            ->join('entidades', 'users.entidade_id', '=', 'entidades.id')
            ->join('roles', 'users.role_id', '=', 'roles.id')
            ->join('estados', 'users.estado_id', '=', 'estados.id')
            ->select('users.*','roles.role')
            ->where(["users.entidade_id"=>$user->entidade_id,"estados.id"=>1])
            ->orderBy("name")
            ->get();
          
            return view('municipio.create',compact('provincias','users','user'));

        }
        else if($user->role_id==3){
            $provincias = Province::get()->where("user_id",$user->id);
            $users = DB::table('users')
                ->join('entidades', 'users.entidade_id', '=', 'entidades.id')
                ->join('roles', 'users.role_id', '=', 'roles.id')
                ->join('estados', 'users.estado_id', '=', 'estados.id')
                ->select('users.*','roles.role')
                ->where(["users.entidade_id"=>$user->entidade_id,"estados.id"=>1])
                ->orderBy("name")
                ->get();
              
                return view('municipio.create',compact('provincias','users','user'));
    
            }
        else{
            abort(403, 'Não autorizado.');
            exit();
        }
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(MunicipioRequest $request)
    {
        
        $user =  auth()->user();
       // dd($user);
        if($user->role_id<5){
            $dados = $request->all();
            $responsavel = User::findOrfail($dados['user']);
            
            $Entidade = entidade::findOrfail($user->entidade_id);
            if($user->role_id==3){
                $prov = Province::findOrfail($dados['provincia'])->where("user_id",$user->id);
            }else{
                $prov = Province::findOrfail($dados['provincia']);
            }
            
            $Municipio = Municipio::create(
                [
                'nome'=>$dados['nome'],
                'codigo'=>$dados['codigo'],
                'latitude'=>$dados['lat'],
                'longitude'=>$dados['long'],
                'precision'=>$dados['precision'],
                'province_id'=>$dados['provincia'],
                'entidade_id'=>$Entidade->id,
                'user_id'=>$responsavel->id, // responsável
                ]
            );
            
            if ($Municipio!=null) {
                $mensagem[0]='Município criado com sucesso!';
            } else {
                $mensagem[0]='';
            }
            
            return redirect()->route('municipio.create');
            
        }else{
            abort(403, 'Não autorizado.');
            exit();
        }
          
    }

    /**
     * Display the specified resource.
     */
    public function show(Municipio $municipio)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(String $id)
    {
      
        if(!isInt($id))
        { 
            $id=0;
        }
         
        $user =  auth()->user();
       
         
        if($user->role_id<5){
            $municipio = Municipio::findOrfail($id);
            if($user->role_id==3){
                // $provincias = Province::findOrfail($municipio->province_id);
                $provincias = Province::get()->where("id",$municipio->province_id);
                if ($provincias!=null) {
                    $users = DB::table('users')
                    ->join('entidades', 'users.entidade_id', '=', 'entidades.id')
                    ->join('roles', 'users.role_id', '=', 'roles.id')
                    ->join('estados', 'users.estado_id', '=', 'estados.id')
                    ->select('users.*','roles.role')
                    ->where(["users.entidade_id"=>$user->entidade_id,"estados.id"=>1])
                    ->orderBy("name")
                    ->get();
                   
                  
                    return view('municipio.edit',compact('municipio','provincias','users','user'));
                } else {
                    abort(403, 'Não autorizado.');
                    exit();
                }
            }
            else
            {
                $provincias = Province::get()->where("entidade_id",$user->entidade_id);
                $users = DB::table('users')
                    ->join('entidades', 'users.entidade_id', '=', 'entidades.id')
                    ->join('roles', 'users.role_id', '=', 'roles.id')
                    ->join('estados', 'users.estado_id', '=', 'estados.id')
                    ->select('users.*','roles.role')
                    ->where(["users.entidade_id"=>$user->entidade_id,"estados.id"=>1])
                    ->orderBy("name")
                    ->get();
                  
                return view('municipio.edit',compact('municipio','provincias','users','user'));
            }
        }else{
            abort(403,'Não autorizado.');
            exit();
        }
 
       
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(MunicipioRequest $request, String $municipio)
    {
        if(!isInt($municipio))
            $id=0;

        $user = auth()->user();
        $municipio = Municipio::findOrFail($municipio);
        $dados = $request->all();
        if($user->role_id==1 or $user->role_id==2){
            if($municipio->entidade_id == $municipio->entidade_id)
            {
                //dd($dados);   
                $municipio->update(
                    [
                    'nome'=>$dados['nome'],
                    'codigo'=>$dados['codigo'],
                    'latitude'=>$dados['lat'],
                    'longitude'=>$dados['long'],
                    'precision'=>$dados['precision'],
                    'province_id'=>$dados['provincia'],
                    'user_id'=>$dados['user'],
                    ]
                );
            }
        }else if($user->role_id==3)
        {
            if($municipio->entidade_id == $municipio->entidade_id /*and $user->id == $Item->responsavelprovincia_id*/)
            {
                //dd($dados);   
                $municipio->update(
                    [
                    'nome'=>$dados['nome'],
                    'codigo'=>$dados['codigo'],
                    'latitude'=>$dados['lat'],
                    'longitude'=>$dados['long'],
                    'precision'=>$dados['precision'],
                   // 'province_id'=>$dados['provincia'],
                    'user_id'=>$dados['user'],
                    ]
                );
            }
        }else{
            abort(403,'Não autorizado.');
            exit();
        }

        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Request $request)
    {
        $id = $request->valor;
        if(!isInt($id))
        { 
            $id=0;
        }
        
        $user =  auth()->user();
        //$Entidade = entidade::findOrfail($user->entidade_id);
        $Municipio = Municipio::findOrfail($id);
        if($user->role_id<5){
            if($user->role_id==3){
                $provincia = Province::findOrfail($Municipio->province_id)->where("user_id",$user->id);
                if ($provincia!=null) {
                    $Municipio->delete(); 
                } else {
                    abort(403, 'Não autorizado.');
                    exit();
                }
            }else{
                $Municipio->delete(); 
            }
            
            if ($Municipio!=null) {
                $mensagem[0]='Município criado com sucesso!';
            } else {
                $mensagem[0]='';
            }
            
            return redirect()->back();
            
        }else{
            abort(403, 'Não autorizado.');
            exit();
        }
          
    }
}
